/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.config;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.creeperhost.minetogether.chat.ChatTarget;
import net.creeperhost.minetogether.repack.blue.endless.jankson.Comment;
import net.creeperhost.minetogether.repack.blue.endless.jankson.Jankson;
import net.creeperhost.minetogether.repack.blue.endless.jankson.JsonGrammar;
import net.creeperhost.minetogether.repack.blue.endless.jankson.JsonPrimitive;
import net.creeperhost.minetogether.repack.blue.endless.jankson.api.SyntaxError;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Jankson JANKSON = Jankson.builder().registerSerializer(Path.class, (p, m) -> JsonPrimitive.of(p.toAbsolutePath().toString())).registerDeserializer(JsonPrimitive.class, Path.class, (p, m) -> Paths.get(p.asString(), new String[0])).build();
    private static final JsonGrammar GRAMMAR = JsonGrammar.JSON5;
    @Nullable
    private static Config INSTANCE;
    @Nullable
    private static Path filePath;
    @Comment(value="For modpack creators. Enter your CurseForge project id here.")
    public String curseProjectID = "";
    @Comment(value="For modpack creators. Enter your 'Promo Code' here.")
    @Nullable
    public String promoCode = "";
    @Comment(value="For modpack creators. The pregen size when selected during orders.")
    public int pregenDiameter = 120;
    @Comment(value="If the Multiplayer server list should have CreeperHost adverts.")
    public boolean mpMenuEnabled = true;
    @Comment(value="If the realms button should be replaced.")
    public boolean replaceRealms = true;
    @Comment(value="If the pause menu buttons should be moved around to insert the Open To Friends button.")
    public boolean moveButtonsOnPauseMenu = true;
    @Comment(value="If all chat messages should be logged to console.")
    public boolean logChatToConsole = false;
    @Comment(value="Create _VERY_ verbose logs. May create hugenorums log files.")
    public boolean debugMode = false;
    @Comment(value="Enables dumping all MTConnect packets to logs.")
    public boolean dumpConnectPackets = false;
    @Comment(value="If the Chat component of MineTogether is enabled.")
    public boolean chatEnabled = true;
    @Comment(value="If notifications for friends are enabled.")
    public boolean friendNotifications = true;
    @Comment(value="If menu buttons are enabled.")
    public boolean mainMenuButtons = true;
    @Comment(value="If pause screen buttons are enabled.")
    public boolean pauseScreenButtons = true;
    @Comment(value="INTERNAL: Marker for tracking first connections.")
    public String firstConnect = "";
    @Comment(value="If not null, replaces the Bug Reports button on the pause screen to open this link.")
    @Nullable
    public String issueTrackerUrl = "https://pste.ch/";
    @Comment(value="Stores the currently selected chat TAB, Ether VANILLA or PUBLIC")
    public ChatTarget selectedTab = ChatTarget.PUBLIC;

    public static Config instance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Config not loaded.");
        }
        return INSTANCE;
    }

    public static void save() {
        assert (INSTANCE != null);
        assert (filePath != null);
        try {
            Files.createDirectories(filePath.toAbsolutePath().getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(filePath, new OpenOption[0]);){
                writer.append(JANKSON.toJson(INSTANCE).toJson(GRAMMAR));
                writer.flush();
            }
        }
        catch (IOException ex) {
            LOGGER.fatal("Failed to save config file to: " + filePath.toAbsolutePath(), (Throwable)ex);
        }
    }

    public static void loadConfig(Path file) {
        Config config;
        if (Files.exists(file, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                config = JANKSON.fromJson(JANKSON.load(is), Config.class);
            }
            catch (IOException | SyntaxError ex) {
                LOGGER.fatal("Failed to read config file from '" + file.toAbsolutePath() + "' - Resetting to default.", (Throwable)ex);
                config = new Config();
            }
        } else {
            config = new Config();
        }
        filePath = file;
        INSTANCE = config;
        Config.save();
    }
}

